/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modrinth;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.curse.CurseForgeRemoteModRepository;
import org.jackhuang.hmcl.mod.modrinth.ModrinthManifest;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.Zipper;
import org.jackhuang.hmcl.util.logging.Logger;

public class ModrinthModpackExportTask
extends Task<Void> {
    private final DefaultGameRepository repository;
    private final String version;
    private final ModpackExportInfo info;
    private final Path modpackFile;
    public static final ModpackExportInfo.Options OPTION = new ModpackExportInfo.Options().requireNoCreateRemoteFiles().requireSkipCurseForgeRemoteFiles();

    public ModrinthModpackExportTask(DefaultGameRepository repository, String version, ModpackExportInfo info, Path modpackFile) {
        this.repository = repository;
        this.version = version;
        this.info = info.validate();
        this.modpackFile = modpackFile;
        this.onDone().register(event -> {
            if (event.isFailed()) {
                try {
                    Files.deleteIfExists(modpackFile);
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to delete modpack file: " + modpackFile, e);
                }
            }
        });
    }

    private ModrinthManifest.File tryGetRemoteFile(Path file, String relativePath) throws IOException {
        long fileSize;
        if (this.info.isNoCreateRemoteFiles()) {
            return null;
        }
        boolean isDisabled = this.repository.getModManager(this.version).isDisabled(file);
        if (isDisabled) {
            relativePath = this.repository.getModManager(this.version).enableMod(Paths.get(relativePath, new String[0])).toString();
        }
        LocalModFile localModFile = null;
        Optional<Object> modrinthVersion = Optional.empty();
        Optional<Object> curseForgeVersion = Optional.empty();
        try {
            modrinthVersion = ModrinthRemoteModRepository.MODS.getRemoteVersionByLocalFile(localModFile, file);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to get remote file from Modrinth for: " + file, e);
        }
        if (!this.info.isSkipCurseForgeRemoteFiles() && CurseForgeRemoteModRepository.isAvailable()) {
            try {
                curseForgeVersion = CurseForgeRemoteModRepository.MODS.getRemoteVersionByLocalFile(localModFile, file);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to get remote file from CurseForge for: " + file, e);
            }
        }
        if (modrinthVersion.isEmpty() && curseForgeVersion.isEmpty()) {
            return null;
        }
        HashMap<String, String> hashes = new HashMap<String, String>();
        hashes.put("sha1", DigestUtils.digestToString("SHA-1", file));
        hashes.put("sha512", DigestUtils.digestToString("SHA-512", file));
        HashMap<String, String> env = null;
        if (isDisabled) {
            env = new HashMap<String, String>();
            env.put("client", "optional");
        }
        ArrayList<String> downloads = new ArrayList<String>();
        if (modrinthVersion.isPresent()) {
            downloads.add(((RemoteMod.Version)modrinthVersion.get()).getFile().getUrl());
        }
        if (curseForgeVersion.isPresent()) {
            downloads.add(((RemoteMod.Version)curseForgeVersion.get()).getFile().getUrl());
        }
        if ((fileSize = Files.size(file)) > Integer.MAX_VALUE) {
            Logger.LOG.warning("File " + relativePath + " is too large (size: " + fileSize + " bytes), precision may be lost when converting to int");
        }
        return new ModrinthManifest.File(relativePath, hashes, env, downloads, (int)fileSize);
    }

    @Override
    public void execute() throws Exception {
        ArrayList<String> blackList = new ArrayList<String>(ModAdviser.MODPACK_BLACK_LIST);
        blackList.add(this.version + ".jar");
        blackList.add(this.version + ".json");
        Logger.LOG.info("Compressing game files without some files in blacklist, including files or directories: usernamecache.json, asm, logs, backups, versions, assets, usercache.json, libraries, crash-reports, launcher_profiles.json, NVIDIA, TCNodeTracker");
        try (Zipper zip = new Zipper(this.modpackFile);){
            String[] resourceDirs;
            Path runDirectory = this.repository.getRunDirectory(this.version);
            ArrayList<ModrinthManifest.File> files = new ArrayList<ModrinthManifest.File>();
            HashSet filesInManifest = new HashSet();
            for (String dir : resourceDirs = new String[]{"resourcepacks", "shaderpacks", "mods"}) {
                Path dirPath = runDirectory.resolve(dir);
                if (!Files.exists(dirPath, new LinkOption[0])) continue;
                Files.walk(dirPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        String relativePath = runDirectory.relativize((Path)file).normalize().toString().replace(File.separatorChar, '/');
                        if (!this.info.getWhitelist().contains(relativePath)) {
                            return;
                        }
                        ModrinthManifest.File fileEntry = this.tryGetRemoteFile((Path)file, relativePath);
                        if (fileEntry != null) {
                            files.add(fileEntry);
                            filesInManifest.add(relativePath);
                        }
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to process file: " + file, e);
                    }
                });
            }
            zip.putDirectory(runDirectory, "client-overrides", path -> {
                String relativePath = path.replace(File.separatorChar, '/');
                if (filesInManifest.contains(relativePath)) {
                    return false;
                }
                return Modpack.acceptFile(path, blackList, this.info.getWhitelist());
            });
            String gameVersion = this.repository.getGameVersion(this.version).orElseThrow(() -> new IOException("Cannot parse the version of " + this.version));
            LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(this.repository.getResolvedPreservingPatchesVersion(this.version), gameVersion);
            HashMap<String, String> dependencies = new HashMap<String, String>();
            dependencies.put("minecraft", gameVersion);
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).ifPresent(forgeVersion -> dependencies.put("forge", (String)forgeVersion));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.NEO_FORGE).ifPresent(neoForgeVersion -> dependencies.put("neoforge", (String)neoForgeVersion));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FABRIC).ifPresent(fabricVersion -> dependencies.put("fabric-loader", (String)fabricVersion));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.QUILT).ifPresent(quiltVersion -> dependencies.put("quilt-loader", (String)quiltVersion));
            ModrinthManifest manifest = new ModrinthManifest("minecraft", 1, this.info.getVersion(), this.info.getName(), this.info.getDescription(), files, dependencies);
            zip.putTextFile(JsonUtils.GSON.toJson(manifest), "modrinth.index.json");
        }
    }
}

