/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.AssetIndexInfo;
import org.jackhuang.hmcl.game.CompatibilityRule;
import org.jackhuang.hmcl.game.DownloadInfo;
import org.jackhuang.hmcl.game.DownloadType;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.OSRestriction;
import org.jackhuang.hmcl.game.RuledArgument;
import org.jackhuang.hmcl.game.StringArgument;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.multimc.MultiMCComponents;
import org.jackhuang.hmcl.mod.multimc.MultiMCManifest;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonMap;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

@Immutable
public final class MultiMCInstancePatch {
    public static final Library BOOTSTRAP_LIBRARY = new Library(new Artifact("org.jackhuang.hmcl", "mmc-bootstrap", "1.0"));
    private final int formatVersion;
    @SerializedName(value="uid")
    private final String id;
    @SerializedName(value="version")
    private final String version;
    @SerializedName(value="assetIndex")
    private final AssetIndexInfo assetIndex;
    @SerializedName(value="minecraftArguments")
    private final String minecraftArguments;
    @SerializedName(value="+jvmArgs")
    private final List<String> jvmArgs;
    @SerializedName(value="mainClass")
    private final String mainClass;
    @SerializedName(value="compatibleJavaMajors")
    private final int[] javaMajors;
    @SerializedName(value="mainJar")
    private final Library mainJar;
    @SerializedName(value="+traits")
    private final List<String> traits;
    @SerializedName(value="+tweakers")
    private final List<String> tweakers;
    @SerializedName(value="+libraries")
    private final List<Library> libraries0;
    @SerializedName(value="libraries")
    private final List<Library> libraries1;
    @SerializedName(value="mavenFiles")
    private final List<Library> mavenFiles;
    @SerializedName(value="jarMods")
    private final List<Library> jarMods;
    @SerializedName(value="requires")
    private final List<MultiMCManifest.MultiMCManifestCachedRequires> requires;

    public MultiMCInstancePatch(int formatVersion, String id, String version, AssetIndexInfo assetIndex, String minecraftArguments, List<String> jvmArgs, String mainClass, int[] javaMajors, Library mainJar, List<String> traits, List<String> tweakers, List<Library> libraries0, List<Library> libraries1, List<Library> mavenFiles, List<Library> jarMods, List<MultiMCManifest.MultiMCManifestCachedRequires> requires) {
        this.formatVersion = formatVersion;
        this.id = id;
        this.version = version;
        this.assetIndex = assetIndex;
        this.minecraftArguments = minecraftArguments;
        this.jvmArgs = jvmArgs;
        this.mainClass = mainClass;
        this.javaMajors = javaMajors;
        this.mainJar = mainJar;
        this.traits = traits;
        this.tweakers = tweakers;
        this.libraries0 = libraries0;
        this.libraries1 = libraries1;
        this.mavenFiles = mavenFiles;
        this.jarMods = jarMods;
        this.requires = requires;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public String getID() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public AssetIndexInfo getAssetIndex() {
        return this.assetIndex;
    }

    public String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public List<String> getJvmArgs() {
        return MultiMCInstancePatch.nonNullOrEmpty(this.jvmArgs);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public int[] getJavaMajors() {
        return this.javaMajors;
    }

    public Library getMainJar() {
        return this.mainJar;
    }

    public List<String> getTraits() {
        return MultiMCInstancePatch.nonNullOrEmpty(this.traits);
    }

    public List<String> getTweakers() {
        return MultiMCInstancePatch.nonNullOrEmpty(this.tweakers);
    }

    public List<Library> getLibraries() {
        ArrayList<Library> list = new ArrayList<Library>();
        if (this.libraries0 != null) {
            list.addAll(this.libraries0);
        }
        if (this.libraries1 != null) {
            list.addAll(this.libraries1);
        }
        return MultiMCInstancePatch.nonNullOrEmpty(list);
    }

    public List<Library> getMavenOnlyFiles() {
        return MultiMCInstancePatch.nonNullOrEmpty(this.mavenFiles);
    }

    public List<Library> getJarMods() {
        return MultiMCInstancePatch.nonNullOrEmpty(this.jarMods);
    }

    public List<MultiMCManifest.MultiMCManifestCachedRequires> getRequires() {
        return MultiMCInstancePatch.nonNullOrEmpty(this.requires);
    }

    private static <T> List<T> nonNullOrEmpty(List<T> value) {
        return value != null && !value.isEmpty() ? value : Collections.emptyList();
    }

    private static <T> List<T> dropDuplicate(List<T> original) {
        HashSet<T> values = new HashSet<T>();
        ArrayList<T> result = new ArrayList<T>();
        for (T item : original) {
            if (!values.add(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static MultiMCInstancePatch read(String componentID, String text) {
        try {
            return JsonUtils.fromNonNullJson(text, MultiMCInstancePatch.class);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Illegal Json-Patch: " + componentID);
        }
    }

    public static ResolvedInstance resolveArtifact(List<MultiMCInstancePatch> patches, String versionID) {
        Version version;
        List<String> jarModFileNames;
        List<Library> mavenOnlyFiles;
        Library mainJar;
        StringBuilder message;
        block26: {
            int i;
            if (patches.isEmpty()) {
                throw new IllegalArgumentException("Empty components.");
            }
            for (MultiMCInstancePatch patch : patches) {
                Objects.requireNonNull(patch, "patch");
                if (patch.getFormatVersion() == 1) continue;
                throw new UnsupportedOperationException(String.format("Unsupported JSON-Patch[%s] format version: %d", patch.getID(), patch.getFormatVersion()));
            }
            message = new StringBuilder();
            ArrayList<Argument> jvmArguments = new ArrayList<Argument>(Arguments.DEFAULT_JVM_ARGUMENTS);
            MultiMCInstancePatch last = patches.get(patches.size() - 1);
            List<String> minecraftArguments = last.getMinecraftArguments() == null ? null : StringUtils.tokenize(last.getMinecraftArguments());
            String mainClass = last.getMainClass();
            AssetIndexInfo assetIndex = last.getAssetIndex();
            int[] javaMajors = last.getJavaMajors();
            mainJar = last.getMainJar();
            List<String> traits = last.getTraits();
            List<String> tweakers = last.getTweakers();
            List<Library> libraries = last.getLibraries();
            mavenOnlyFiles = last.getMavenOnlyFiles();
            jarModFileNames = last.getJarMods().stream().map(Library::getFileName).collect(Collectors.toList());
            for (i = patches.size() - 2; i >= 0; --i) {
                MultiMCInstancePatch patch;
                if (minecraftArguments == null & (patch = patches.get(i)).getMinecraftArguments() != null) {
                    minecraftArguments = StringUtils.tokenize(patch.getMinecraftArguments());
                }
                for (String jvmArg : patch.getJvmArgs()) {
                    jvmArguments.add(new StringArgument(jvmArg));
                }
                mainClass = Lang.requireNonNullElse(mainClass, patch.getMainClass());
                assetIndex = Lang.requireNonNullElse(patch.getAssetIndex(), assetIndex);
                javaMajors = Lang.requireNonNullElse(patch.getJavaMajors(), javaMajors);
                mainJar = Lang.requireNonNullElse(patch.getMainJar(), mainJar);
                traits = Lang.merge(patch.getTraits(), traits);
                tweakers = Lang.merge(patch.getTweakers(), tweakers);
                libraries = Lang.merge(patch.getLibraries(), libraries);
                mavenOnlyFiles = Lang.merge(patch.getMavenOnlyFiles(), mavenOnlyFiles);
                jarModFileNames = Lang.merge(patch.getJarMods().stream().map(Library::getFileName).collect(Collectors.toList()), jarModFileNames);
            }
            mainClass = Lang.requireNonNullElse(mainClass, "net.minecraft.client.Minecraft");
            if (minecraftArguments == null) {
                minecraftArguments = new ArrayList<String>();
            }
            for (i = minecraftArguments.size() - 2; i >= 0; --i) {
                if (!"--tweakClass".equals(minecraftArguments.get(i))) continue;
                tweakers.add(minecraftArguments.get(i + 1));
                minecraftArguments.remove(i);
                minecraftArguments.remove(i);
            }
            traits = MultiMCInstancePatch.dropDuplicate(traits);
            tweakers = MultiMCInstancePatch.dropDuplicate(tweakers);
            jarModFileNames = MultiMCInstancePatch.dropDuplicate(jarModFileNames);
            for (String tweaker : tweakers) {
                minecraftArguments.add("--tweakClass");
                minecraftArguments.add(tweaker);
            }
            block15: for (String trait : traits) {
                switch (trait) {
                    case "FirstThreadOnMacOS": {
                        jvmArguments.add(new RuledArgument(Collections.singletonList(new CompatibilityRule(CompatibilityRule.Action.ALLOW, new OSRestriction(OperatingSystem.MACOS))), Collections.singletonList("-XstartOnFirstThread")));
                        continue block15;
                    }
                    case "XR:Initial": 
                    case "texturepacks": 
                    case "no-texturepacks": {
                        continue block15;
                    }
                }
                message.append(" - Trait: ").append(trait).append('\n');
            }
            for (Library library : libraries) {
                Artifact artifact = library.getArtifact();
                if (!"io.github.zekerzhayard".equals(artifact.getGroup()) || !"ForgeWrapper".equals(artifact.getName())) continue;
                jvmArguments.add(new StringArgument("-Dforgewrapper.librariesDir=${library_directory}"));
                jvmArguments.add(new StringArgument("-Dforgewrapper.minecraft=${primary_jar}"));
                for (Library lib : libraries) {
                    Artifact ar = lib.getArtifact();
                    if ((!"net.neoforged".equals(ar.getGroup()) || !"neoforge".equals(ar.getName()) || !"installer".equals(ar.getClassifier())) && (!"net.minecraftforge".equals(ar.getGroup()) || !"forge".equals(ar.getName()) || !"installer".equals(ar.getClassifier()))) continue;
                    jvmArguments.add(new StringArgument("-Dforgewrapper.installer=${library_directory}/" + ar.getPath()));
                }
            }
            libraries.add(0, BOOTSTRAP_LIBRARY);
            jvmArguments.add(new StringArgument("-Dhmcl.mmc.bootstrap=" + NetworkUtils.withQuery("hmcl:///bootstrap_profile_v1/", Map.of("main_class", mainClass, "installer", MultiMCComponents.getInstallerProfile()))));
            mainClass = "org.jackhuang.hmcl.HMCLMultiMCBootstrap";
            version = new Version(versionID).setArguments(new Arguments().addGameArguments(minecraftArguments).addJVMArgumentsDirect(jvmArguments)).setMainClass(mainClass).setLibraries(libraries).setAssetIndex(assetIndex).setDownload(new JsonMap<DownloadType, DownloadInfo>(Collections.singletonMap(DownloadType.CLIENT, mainJar.getRawDownloadInfo())));
            if (javaMajors != null) {
                javaMajors = (int[])javaMajors.clone();
                Arrays.sort(javaMajors);
                for (int i2 = javaMajors.length - 1; i2 >= 0; --i2) {
                    GameJavaVersion jv = GameJavaVersion.get(javaMajors[i2]);
                    if (jv == null) continue;
                    version = version.setJavaVersion(jv);
                    break block26;
                }
                message.append(" - Java Version Range: ").append(Arrays.toString(javaMajors)).append('\n');
            }
        }
        version = version.markAsResolved();
        String gameVersion = null;
        for (MultiMCInstancePatch patch : patches) {
            if (MultiMCComponents.getComponent(patch.getID()) != LibraryAnalyzer.LibraryType.MINECRAFT) continue;
            gameVersion = patch.getVersion();
            break;
        }
        if (message.length() != 0) {
            if (message.charAt(message.length() - 1) == '\n') {
                message.setLength(message.length() - 1);
            }
            Logger.LOG.warning("Cannot fully parse MultiMC modpack with following unsupported features: \n" + message);
        }
        return new ResolvedInstance(version, gameVersion, mainJar, jarModFileNames, mavenOnlyFiles);
    }

    public static final class ResolvedInstance {
        private final Version version;
        private final String gameVersion;
        private final Library mainJar;
        private final List<String> jarModFileNames;
        private final List<Library> mavenOnlyFiles;

        public ResolvedInstance(Version version, String gameVersion, Library mainJar, List<String> jarModFileNames, List<Library> mavenOnlyFiles) {
            this.version = version;
            this.gameVersion = gameVersion;
            this.mainJar = mainJar;
            this.jarModFileNames = jarModFileNames;
            this.mavenOnlyFiles = mavenOnlyFiles;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getGameVersion() {
            return this.gameVersion;
        }

        public Library getMainJar() {
            return this.mainJar;
        }

        public List<String> getJarModFileNames() {
            return this.jarModFileNames;
        }

        public List<Library> getMavenOnlyFiles() {
            return this.mavenOnlyFiles;
        }
    }
}

