/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProxyManager {
    private static final SimpleProxySelector NO_PROXY = new SimpleProxySelector(Proxy.NO_PROXY);
    private static final ProxySelector SYSTEM_DEFAULT;
    @NotNull
    private static volatile ProxySelector defaultProxySelector;
    @Nullable
    private static volatile SimpleAuthenticator defaultAuthenticator;

    private static ProxySelector getProxySelector() {
        if (ConfigHolder.config().hasProxy()) {
            Proxy.Type proxyType = ConfigHolder.config().getProxyType();
            String host = ConfigHolder.config().getProxyHost();
            int port = ConfigHolder.config().getProxyPort();
            if (proxyType == Proxy.Type.DIRECT || StringUtils.isBlank(host)) {
                return NO_PROXY;
            }
            if (port < 0 || port > 65535) {
                Logger.LOG.warning("Illegal proxy port: " + port);
                return NO_PROXY;
            }
            return new ProxySelectorWrapper(new SimpleProxySelector(new Proxy(proxyType, new InetSocketAddress(host, port))));
        }
        return SYSTEM_DEFAULT;
    }

    private static SimpleAuthenticator getAuthenticator() {
        if (ConfigHolder.config().hasProxy() && ConfigHolder.config().hasProxyAuth()) {
            String username = ConfigHolder.config().getProxyUser();
            String password = ConfigHolder.config().getProxyPass();
            if (username != null || password != null) {
                return new SimpleAuthenticator(Objects.requireNonNullElse(username, ""), Objects.requireNonNullElse(password, "").toCharArray());
            }
            return null;
        }
        return null;
    }

    static void init() {
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return defaultProxySelector.select(uri);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                defaultProxySelector.connectFailed(uri, sa, ioe);
            }
        });
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                SimpleAuthenticator defaultAuthenticator = ProxyManager.defaultAuthenticator;
                return defaultAuthenticator != null ? defaultAuthenticator.getPasswordAuthentication() : null;
            }
        });
        defaultProxySelector = ProxyManager.getProxySelector();
        InvalidationListener updateProxySelector = observable -> {
            defaultProxySelector = ProxyManager.getProxySelector();
        };
        ConfigHolder.config().proxyTypeProperty().addListener(updateProxySelector);
        ConfigHolder.config().proxyHostProperty().addListener(updateProxySelector);
        ConfigHolder.config().proxyPortProperty().addListener(updateProxySelector);
        ConfigHolder.config().hasProxyProperty().addListener(updateProxySelector);
        defaultAuthenticator = ProxyManager.getAuthenticator();
        InvalidationListener updateAuthenticator = observable -> {
            defaultAuthenticator = ProxyManager.getAuthenticator();
        };
        ConfigHolder.config().hasProxyProperty().addListener(updateAuthenticator);
        ConfigHolder.config().hasProxyAuthProperty().addListener(updateAuthenticator);
        ConfigHolder.config().proxyUserProperty().addListener(updateAuthenticator);
        ConfigHolder.config().proxyPassProperty().addListener(updateAuthenticator);
    }

    private ProxyManager() {
    }

    static {
        ProxySelector systemProxySelector = ProxySelector.getDefault();
        defaultProxySelector = SYSTEM_DEFAULT = systemProxySelector != null ? new ProxySelectorWrapper(systemProxySelector) : NO_PROXY;
        defaultAuthenticator = null;
    }

    private static final class SimpleProxySelector
    extends AbstractProxySelector {
        private final List<Proxy> proxies;

        SimpleProxySelector(Proxy proxy) {
            this.proxies = List.of(proxy);
        }

        @Override
        public List<Proxy> select(URI uri) {
            if (uri == null) {
                throw new IllegalArgumentException("URI can't be null.");
            }
            return this.proxies;
        }

        public String toString() {
            return "SimpleProxySelector" + this.proxies;
        }
    }

    private static final class ProxySelectorWrapper
    extends AbstractProxySelector {
        private final ProxySelector source;

        ProxySelectorWrapper(ProxySelector source) {
            this.source = source;
        }

        @Override
        public List<Proxy> select(URI uri) {
            if (uri == null) {
                throw new IllegalArgumentException("URI can't be null.");
            }
            if (NetworkUtils.isLoopbackAddress(uri)) {
                return ProxyManager.NO_PROXY.proxies;
            }
            return this.source.select(uri);
        }
    }

    private static final class SimpleAuthenticator
    extends Authenticator {
        private final String username;
        private final char[] password;

        private SimpleAuthenticator(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return this.getRequestorType() == Authenticator.RequestorType.PROXY ? new PasswordAuthentication(this.username, this.password) : null;
        }
    }

    private static abstract class AbstractProxySelector
    extends ProxySelector {
        private AbstractProxySelector() {
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            if (uri == null || sa == null || ioe == null) {
                throw new IllegalArgumentException("Arguments can't be null.");
            }
        }
    }
}

