/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.util.CacheRepository;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class CacheFileTask
extends FetchTask<Path> {
    public CacheFileTask(@NotNull String uri) {
        this(NetworkUtils.toURI(uri));
    }

    public CacheFileTask(@NotNull URI uri) {
        super(List.of(uri));
        this.setName(uri.toString());
    }

    @Override
    protected FetchTask.EnumCheckETag shouldCheckETag() {
        for (URI uri : this.uris) {
            try {
                this.setResult(this.repository.getCachedRemoteFile(uri, true));
                Logger.LOG.info("Using cached file for " + NetworkUtils.dropQuery(uri));
                return FetchTask.EnumCheckETag.CACHED;
            }
            catch (CacheRepository.CacheExpiredException e) {
                Logger.LOG.info("Cache expired for " + NetworkUtils.dropQuery(uri));
            }
            catch (IOException iOException) {
            }
        }
        return FetchTask.EnumCheckETag.CHECK_E_TAG;
    }

    @Override
    protected void useCachedResult(Path cache) {
        this.setResult(cache);
    }

    @Override
    protected FetchTask.Context getContext(final URLConnection connection, boolean checkETag, String bmclapiHash) throws IOException {
        assert (checkETag);
        final Path temp = Files.createTempFile("hmcl-download-", null, new FileAttribute[0]);
        final OutputStream fileOutput = Files.newOutputStream(temp, new OpenOption[0]);
        return new FetchTask.Context(){

            @Override
            public void write(byte[] buffer, int offset, int len) throws IOException {
                fileOutput.write(buffer, offset, len);
            }

            @Override
            public void close() throws IOException {
                try {
                    fileOutput.close();
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to close file: " + temp, e);
                }
                if (!this.isSuccess()) {
                    try {
                        Files.deleteIfExists(temp);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to delete file: " + temp, e);
                    }
                    return;
                }
                try {
                    CacheFileTask.this.setResult(CacheFileTask.this.repository.cacheRemoteFile(connection, temp));
                }
                finally {
                    try {
                        Files.deleteIfExists(temp);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to delete file: " + temp, e);
                    }
                }
            }
        };
    }
}

