/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXTextField;
import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.i18n.I18n;

public class InputDialogPane
extends JFXDialogLayout {
    private final CompletableFuture<String> future = new CompletableFuture();
    private final JFXTextField textField;
    private final Label lblCreationWarning;
    private final SpinnerPane acceptPane;

    public InputDialogPane(String text, String initialValue, FutureCallback<String> onResult) {
        this.textField = new JFXTextField(initialValue);
        this.setHeading(new Node[]{new HBox(new Node[]{new Label(text)})});
        this.setBody(new Node[]{new VBox(new Node[]{this.textField})});
        this.lblCreationWarning = new Label();
        this.acceptPane = new SpinnerPane();
        this.acceptPane.getStyleClass().add((Object)"small-spinner-pane");
        JFXButton acceptButton = new JFXButton(I18n.i18n("button.ok"));
        acceptButton.getStyleClass().add((Object)"dialog-accept");
        this.acceptPane.setContent((Node)acceptButton);
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"dialog-cancel");
        this.setActions(new Node[]{this.lblCreationWarning, this.acceptPane, cancelButton});
        cancelButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
        acceptButton.setOnAction(e -> {
            this.acceptPane.showSpinner();
            onResult.call(this.textField.getText(), () -> {
                this.acceptPane.hideSpinner();
                this.future.complete(this.textField.getText());
                this.fireEvent(new DialogCloseEvent());
            }, msg -> {
                this.acceptPane.hideSpinner();
                this.lblCreationWarning.setText(msg);
            });
        });
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
    }

    public CompletableFuture<String> getCompletableFuture() {
        return this.future;
    }
}

