/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.TaskListPane;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jetbrains.annotations.NotNull;

public class TaskExecutorDialogPane
extends BorderPane {
    private TaskExecutor executor;
    private TaskCancellationAction onCancel;
    private final Consumer<FetchTask.SpeedEvent> speedEventHandler;
    private final Label lblTitle;
    private final Label lblProgress;
    private final JFXButton btnCancel;
    private final TaskListPane taskListPane;

    public TaskExecutorDialogPane(@NotNull TaskCancellationAction cancel) {
        FXUtils.setLimitWidth((Region)this, 500.0);
        FXUtils.setLimitHeight((Region)this, 300.0);
        VBox center = new VBox();
        this.setCenter((Node)center);
        center.setPadding(new Insets(16.0));
        this.lblTitle = new Label();
        this.lblTitle.setStyle("-fx-font-size: 14px; -fx-font-weight: BOLD;");
        this.taskListPane = new TaskListPane();
        VBox.setVgrow((Node)this.taskListPane, (Priority)Priority.ALWAYS);
        center.getChildren().setAll((Object[])new Node[]{this.lblTitle, this.taskListPane});
        BorderPane bottom = new BorderPane();
        this.setBottom((Node)bottom);
        bottom.setPadding(new Insets(0.0, 8.0, 8.0, 8.0));
        this.lblProgress = new Label();
        bottom.setLeft((Node)this.lblProgress);
        this.btnCancel = new JFXButton(I18n.i18n("button.cancel"));
        bottom.setRight((Node)this.btnCancel);
        this.setCancel(cancel);
        this.btnCancel.setOnAction(e -> {
            Optional.ofNullable(this.executor).ifPresent(TaskExecutor::cancel);
            if (this.onCancel.getCancellationAction() != null) {
                this.onCancel.getCancellationAction().accept(this);
            }
        });
        this.speedEventHandler = speedEvent -> {
            String unit = "B/s";
            double speed = speedEvent.getSpeed();
            if (speed > 1024.0) {
                speed /= 1024.0;
                unit = "KiB/s";
            }
            if (speed > 1024.0) {
                speed /= 1024.0;
                unit = "MiB/s";
            }
            double finalSpeed = speed;
            String finalUnit = unit;
            Platform.runLater(() -> this.lblProgress.setText(String.format("%.1f %s", finalSpeed, finalUnit)));
        };
        FileDownloadTask.speedEvent.channel(FetchTask.SpeedEvent.class).registerWeak(this.speedEventHandler);
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)this.btnCancel).fire());
    }

    public void setExecutor(TaskExecutor executor) {
        this.setExecutor(executor, true);
    }

    public void setExecutor(TaskExecutor executor, boolean autoClose) {
        this.executor = executor;
        if (executor != null) {
            this.taskListPane.setExecutor(executor);
            if (autoClose) {
                executor.addTaskListener(new TaskListener(){

                    @Override
                    public void onStop(boolean success, TaskExecutor executor) {
                        Platform.runLater(() -> TaskExecutorDialogPane.this.fireEvent(new DialogCloseEvent()));
                    }
                });
            }
        }
    }

    public StringProperty titleProperty() {
        return this.lblTitle.textProperty();
    }

    public String getTitle() {
        return this.lblTitle.getText();
    }

    public void setTitle(String currentState) {
        this.lblTitle.setText(currentState);
    }

    public void setCancel(TaskCancellationAction onCancel) {
        this.onCancel = onCancel;
        FXUtils.runInFX(() -> this.btnCancel.setDisable(onCancel == null));
    }
}

