/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import javafx.scene.Node;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.download.InstallersPage;
import org.jackhuang.hmcl.ui.download.ModpackPage;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.download.VersionsPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class VanillaInstallWizardProvider
implements WizardProvider {
    private final Profile profile;
    private final DefaultDependencyManager dependencyManager;
    private final DownloadProvider downloadProvider;

    public VanillaInstallWizardProvider(Profile profile) {
        this.profile = profile;
        this.downloadProvider = DownloadProviders.getDownloadProvider();
        this.dependencyManager = profile.getDependency(this.downloadProvider);
    }

    @Override
    public void start(SettingsMap settings) {
        settings.put(ModpackPage.PROFILE, this.profile);
    }

    private Task<Void> finishVersionDownloadingAsync(SettingsMap settings) {
        GameBuilder builder = this.dependencyManager.gameBuilder();
        String name = (String)settings.get("name");
        builder.name(name);
        builder.gameVersion(((RemoteVersion)settings.get("game")).getGameVersion());
        settings.asStringMap().forEach((key, value) -> {
            if (!"game".equals(key) && value instanceof RemoteVersion) {
                RemoteVersion remoteVersion = (RemoteVersion)value;
                builder.version(remoteVersion);
            }
        });
        return builder.buildAsync().whenComplete(any -> this.profile.getRepository().refreshVersions()).thenRunAsync(Schedulers.javafx(), () -> this.profile.setSelectedVersion(name));
    }

    @Override
    public Object finish(SettingsMap settings) {
        settings.put("title", I18n.i18n("install.new_game.installation"));
        settings.put("success_message", I18n.i18n("install.success"));
        settings.put(WizardProvider.FailureCallback.KEY, (settings1, exception, next) -> UpdateInstallerWizardProvider.alertFailureMessage(exception, next));
        return this.finishVersionDownloadingAsync(settings);
    }

    @Override
    public Node createPage(WizardController controller, int step, SettingsMap settings) {
        switch (step) {
            case 0: {
                return new VersionsPage(controller, I18n.i18n("install.installer.choose", I18n.i18n("install.installer.game")), "", this.downloadProvider, "game", () -> controller.onNext((Node)new InstallersPage(controller, this.profile.getRepository(), ((RemoteVersion)controller.getSettings().get("game")).getGameVersion(), this.downloadProvider)));
            }
        }
        throw new IllegalStateException("error step " + step + ", settings: " + settings + ", pages: " + controller.getPages());
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

