/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.image;

import com.twelvemonkeys.imageio.plugins.webp.WebPImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jackhuang.hmcl.ui.image.ImageLoader;
import org.jackhuang.hmcl.ui.image.apng.Png;
import org.jackhuang.hmcl.ui.image.apng.argb8888.Argb8888Bitmap;
import org.jackhuang.hmcl.ui.image.apng.argb8888.Argb8888BitmapSequence;
import org.jackhuang.hmcl.ui.image.apng.chunks.PngAnimationControl;
import org.jackhuang.hmcl.ui.image.apng.chunks.PngFrameControl;
import org.jackhuang.hmcl.ui.image.apng.error.PngException;
import org.jackhuang.hmcl.ui.image.apng.error.PngIntegrityException;
import org.jackhuang.hmcl.ui.image.internal.AnimationImageImpl;
import org.jackhuang.hmcl.util.SwingFXUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class ImageUtils {
    public static final ImageLoader DEFAULT = (input, requestedWidth, requestedHeight, preserveRatio, smooth) -> {
        Image image = new Image(input, (double)requestedWidth, (double)requestedHeight, preserveRatio, smooth);
        if (image.isError()) {
            throw image.getException();
        }
        return image;
    };
    public static final ImageLoader WEBP = (input, requestedWidth, requestedHeight, preserveRatio, smooth) -> {
        BufferedImage bufferedImage;
        WebPImageReaderSpi spi = new WebPImageReaderSpi();
        ImageReader reader = spi.createReaderInstance(null);
        try (ImageInputStream imageInput = ImageIO.createImageInputStream(input);){
            reader.setInput(imageInput, true, true);
            bufferedImage = reader.read(0, reader.getDefaultReadParam());
        }
        finally {
            reader.dispose();
        }
        return SwingFXUtils.toFXImage(bufferedImage, requestedWidth, requestedHeight, preserveRatio, smooth);
    };
    public static final ImageLoader APNG = (input, requestedWidth, requestedHeight, preserveRatio, smooth) -> {
        if (!"true".equals(System.getProperty("hmcl.experimental.apng", "true"))) {
            return DEFAULT.load(input, requestedWidth, requestedHeight, preserveRatio, smooth);
        }
        try {
            int[] pixels;
            int targetHeight;
            int targetWidth;
            boolean doScale;
            Argb8888BitmapSequence sequence = Png.readArgb8888BitmapSequence(input);
            int width = sequence.header.width;
            int height = sequence.header.height;
            if (requestedWidth > 0 && requestedHeight > 0 && (requestedWidth != width || requestedHeight != height)) {
                doScale = true;
                if (preserveRatio) {
                    double scaleX = (double)requestedWidth / (double)width;
                    double scaleY = (double)requestedHeight / (double)height;
                    double scale = Math.min(scaleX, scaleY);
                    requestedWidth = (int)((double)width * scale);
                    requestedHeight = (int)((double)height * scale);
                }
            } else {
                doScale = false;
            }
            if (sequence.isAnimated()) {
                try {
                    return ImageUtils.toImage(sequence, doScale, requestedWidth, requestedHeight);
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Failed to load animated image", e);
                }
            }
            Argb8888Bitmap defaultImage = sequence.defaultImage;
            if (doScale) {
                targetWidth = requestedWidth;
                targetHeight = requestedHeight;
                pixels = ImageUtils.scale(defaultImage.array, defaultImage.width, defaultImage.height, targetWidth, targetHeight);
            } else {
                targetWidth = defaultImage.width;
                targetHeight = defaultImage.height;
                pixels = defaultImage.array;
            }
            WritableImage image = new WritableImage(targetWidth, targetHeight);
            image.getPixelWriter().setPixels(0, 0, targetWidth, targetHeight, (PixelFormat)PixelFormat.getIntArgbInstance(), pixels, 0, targetWidth);
            return image;
        }
        catch (PngException e) {
            throw new IOException(e);
        }
    };
    public static final Map<String, ImageLoader> EXT_TO_LOADER = Map.of("webp", WEBP, "apng", APNG);
    public static final Map<String, ImageLoader> CONTENT_TYPE_TO_LOADER = Map.of("image/webp", WEBP, "image/apng", APNG);
    public static final Set<String> DEFAULT_EXTS = Set.of("jpg", "jpeg", "bmp", "gif");
    public static final Set<String> DEFAULT_CONTENT_TYPES = Set.of("image/jpeg", "image/bmp", "image/gif");
    public static final int HEADER_BUFFER_SIZE = 1024;
    private static final byte[] RIFF_HEADER = new byte[]{82, 73, 70, 70};
    private static final byte[] WEBP_HEADER = new byte[]{87, 69, 66, 80};
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("^\\s(?<type>image/[\\w-])");

    public static boolean isWebP(byte[] headerBuffer) {
        return headerBuffer.length > 12 && Arrays.equals(headerBuffer, 0, 4, RIFF_HEADER, 0, 4) && Arrays.equals(headerBuffer, 8, 12, WEBP_HEADER, 0, 4);
    }

    public static boolean isApng(byte[] headerBuffer) {
        PngChunkHeader header;
        if (headerBuffer.length <= 20) {
            return false;
        }
        if (!Arrays.equals(headerBuffer, 0, 8, PNG_HEADER, 0, 8)) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.wrap(headerBuffer, 8, headerBuffer.length - 8);
        while ((header = PngChunkHeader.readHeader(buffer)) != null && header.chunkType != 1229209940) {
            if (header.chunkType == 1633899596) {
                return true;
            }
            int numBytes = header.length + 4;
            if (buffer.remaining() <= numBytes) break;
            buffer.position(buffer.position() + numBytes);
        }
        return false;
    }

    @Nullable
    public static ImageLoader guessLoader(byte[] headerBuffer) {
        if (ImageUtils.isWebP(headerBuffer)) {
            return WEBP;
        }
        if (ImageUtils.isApng(headerBuffer)) {
            return APNG;
        }
        return null;
    }

    private static int[] scale(int[] pixels, int sourceWidth, int sourceHeight, int targetWidth, int targetHeight) {
        assert (pixels.length == sourceWidth * sourceHeight);
        double xScale = (double)sourceWidth / (double)targetWidth;
        double yScale = (double)sourceHeight / (double)targetHeight;
        int[] result = new int[targetWidth * targetHeight];
        for (int row = 0; row < targetHeight; ++row) {
            for (int col = 0; col < targetWidth; ++col) {
                int color;
                int sourceX = (int)((double)col * xScale);
                int sourceY = (int)((double)row * yScale);
                result[row * targetWidth + col] = color = pixels[sourceY * sourceWidth + sourceX];
            }
        }
        return result;
    }

    private static Image toImage(Argb8888BitmapSequence sequence, boolean doScale, int targetWidth, int targetHeight) throws PngException {
        int cycleCount;
        int width = sequence.header.width;
        int height = sequence.header.height;
        List<Argb8888BitmapSequence.Frame> frames = sequence.getAnimationFrames();
        int[][] framePixels = new int[frames.size()][];
        int[] durations = new int[framePixels.length];
        int[] buffer = new int[Math.multiplyExact(width, height)];
        block5: for (int frameIndex = 0; frameIndex < frames.size(); ++frameIndex) {
            int row;
            Argb8888BitmapSequence.Frame frame = frames.get(frameIndex);
            PngFrameControl control = frame.control;
            if (frameIndex == 0 && (control.xOffset != 0 || control.yOffset != 0 || control.width != width || control.height != height)) {
                throw new PngIntegrityException("Invalid first frame: " + control);
            }
            if (control.xOffset < 0 || control.yOffset < 0 || width < 0 || height < 0 || control.xOffset + control.width > width || control.yOffset + control.height > height || control.delayNumerator < 0 || control.delayDenominator < 0) {
                throw new PngIntegrityException("Invalid frame control: " + control);
            }
            int[] currentFrameBuffer = (int[])buffer.clone();
            if (control.blendOp == 0) {
                for (row = 0; row < control.height; ++row) {
                    System.arraycopy(frame.bitmap.array, row * control.width, currentFrameBuffer, (control.yOffset + row) * width + control.xOffset, control.width);
                }
            } else if (control.blendOp == 1) {
                for (row = 0; row < control.height; ++row) {
                    for (int col = 0; col < control.width; ++col) {
                        int outR;
                        int outG;
                        int outB;
                        int srcIndex = row * control.width + col;
                        int dstIndex = (control.yOffset + row) * width + control.xOffset + col;
                        int srcPixel = frame.bitmap.array[srcIndex];
                        int dstPixel = currentFrameBuffer[dstIndex];
                        int srcAlpha = srcPixel >>> 24 & 0xFF;
                        if (srcAlpha == 0) continue;
                        if (srcAlpha == 255) {
                            currentFrameBuffer[dstIndex] = srcPixel;
                            continue;
                        }
                        int srcR = srcPixel >>> 16 & 0xFF;
                        int srcG = srcPixel >>> 8 & 0xFF;
                        int srcB = srcPixel & 0xFF;
                        int dstAlpha = dstPixel >>> 24 & 0xFF;
                        int dstR = dstPixel >>> 16 & 0xFF;
                        int dstG = dstPixel >>> 8 & 0xFF;
                        int dstB = dstPixel & 0xFF;
                        int invSrcAlpha = 255 - srcAlpha;
                        int outAlpha = srcAlpha + (dstAlpha * invSrcAlpha + 127) / 255;
                        if (outAlpha == 0) {
                            outB = 0;
                            outG = 0;
                            outR = 0;
                        } else {
                            outR = (srcR * srcAlpha + dstR * dstAlpha * invSrcAlpha / 255 + outAlpha / 2) / outAlpha;
                            outG = (srcG * srcAlpha + dstG * dstAlpha * invSrcAlpha / 255 + outAlpha / 2) / outAlpha;
                            outB = (srcB * srcAlpha + dstB * dstAlpha * invSrcAlpha / 255 + outAlpha / 2) / outAlpha;
                        }
                        outAlpha = Math.min(outAlpha, 255);
                        outR = Math.min(outR, 255);
                        outG = Math.min(outG, 255);
                        outB = Math.min(outB, 255);
                        currentFrameBuffer[dstIndex] = outAlpha << 24 | outR << 16 | outG << 8 | outB;
                    }
                }
            } else {
                throw new PngIntegrityException("Unsupported blendOp " + control.blendOp + " at frame " + frameIndex);
            }
            framePixels[frameIndex] = doScale ? ImageUtils.scale(currentFrameBuffer, width, height, targetWidth, targetHeight) : currentFrameBuffer;
            if (control.delayNumerator == 0) {
                durations[frameIndex] = 10;
            } else {
                int durationsMills = 1000 * control.delayNumerator;
                durationsMills = control.delayDenominator == 0 ? (durationsMills /= 100) : (durationsMills /= control.delayDenominator);
                durations[frameIndex] = durationsMills;
            }
            switch (control.disposeOp) {
                case 0: {
                    System.arraycopy(currentFrameBuffer, 0, buffer, 0, currentFrameBuffer.length);
                    continue block5;
                }
                case 1: {
                    for (row = 0; row < control.height; ++row) {
                        int fromIndex = (control.yOffset + row) * width + control.xOffset;
                        Arrays.fill(buffer, fromIndex, fromIndex + control.width, 0);
                    }
                    continue block5;
                }
                case 2: {
                    continue block5;
                }
                default: {
                    throw new PngIntegrityException("Unsupported disposeOp " + control.disposeOp + " at frame " + frameIndex);
                }
            }
        }
        PngAnimationControl animationControl = sequence.getAnimationControl();
        if (animationControl != null) {
            cycleCount = animationControl.numPlays;
            if (cycleCount == 0) {
                cycleCount = -1;
            }
        } else {
            cycleCount = -1;
        }
        if (doScale) {
            return new AnimationImageImpl(targetWidth, targetHeight, framePixels, durations, cycleCount);
        }
        return new AnimationImageImpl(width, height, framePixels, durations, cycleCount);
    }

    private ImageUtils() {
    }

    private static final class PngChunkHeader {
        private static final int IDAT_HEADER = 1229209940;
        private static final int acTL_HEADER = 1633899596;
        private final int length;
        private final int chunkType;

        private PngChunkHeader(int length, int chunkType) {
            this.length = length;
            this.chunkType = chunkType;
        }

        @Nullable
        private static PngChunkHeader readHeader(ByteBuffer headerBuffer) {
            if (headerBuffer.remaining() < 8) {
                return null;
            }
            int length = headerBuffer.getInt();
            int chunkType = headerBuffer.getInt();
            return new PngChunkHeader(length, chunkType);
        }
    }
}

