/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.download.java.JavaRemoteVersion;
import org.jackhuang.hmcl.download.java.disco.DiscoJavaDistribution;
import org.jackhuang.hmcl.download.java.disco.DiscoJavaRemoteVersion;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.java.JavaManager;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.wizard.WizardSinglePage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class JavaInstallPage
extends WizardSinglePage {
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z0-9.\\-_]+");
    private final Path file;
    private final JavaInfo info;
    private final JavaRemoteVersion remoteVersion;
    private final Map<String, Object> update;
    private final StringProperty nameProperty = new SimpleStringProperty();

    public JavaInstallPage(Runnable onFinish, JavaInfo info, JavaRemoteVersion remoteVersion, Map<String, Object> update, String defaultName, Path file) {
        super(onFinish);
        this.info = info;
        this.remoteVersion = remoteVersion;
        this.update = update;
        this.file = file;
        this.nameProperty.set((Object)defaultName);
    }

    protected SkinBase<?> createDefaultSkin() {
        return new Skin(this);
    }

    @Override
    protected Object finish() {
        Task<JavaRuntime> installTask = JavaManager.getInstallJavaTask(this.info.getPlatform(), (String)this.nameProperty.get(), this.update, this.file);
        return this.remoteVersion == null ? installTask : installTask.whenComplete(exception -> {
            try {
                Files.delete(this.file);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to delete file: " + this.file, e);
            }
        });
    }

    @Override
    public String getTitle() {
        return I18n.i18n("java.install");
    }

    private static final class Skin
    extends SkinBase<JavaInstallPage> {
        private final ComponentList componentList = new ComponentList();
        private final JFXTextField nameField;
        private final Set<String> usedNames = new HashSet<String>();

        Skin(JavaInstallPage control) {
            super((Control)control);
            VBox borderPane = new VBox();
            borderPane.setAlignment(Pos.CENTER);
            FXUtils.setLimitWidth((Region)borderPane, 500.0);
            BorderPane namePane = new BorderPane();
            Label label = new Label(I18n.i18n("java.install.name"));
            BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
            namePane.setLeft((Node)label);
            this.nameField = new JFXTextField();
            this.nameField.textProperty().bindBidirectional((Property)control.nameProperty);
            FXUtils.setLimitWidth((Region)this.nameField, 200.0);
            BorderPane.setAlignment((Node)this.nameField, (Pos)Pos.CENTER_RIGHT);
            BorderPane.setMargin((Node)this.nameField, (Insets)new Insets(0.0, 0.0, 12.0, 0.0));
            namePane.setRight((Node)this.nameField);
            this.nameField.setValidators(new RequiredValidator(), new Validator(I18n.i18n("java.install.warning.invalid_character"), text -> !text.startsWith("mojang-") && NAME_PATTERN.matcher((CharSequence)text).matches()), new Validator(I18n.i18n("java.install.failed.exists"), text -> !this.usedNames.contains(text)));
            String defaultName = (String)control.nameProperty.get();
            if (JavaManager.REPOSITORY.isInstalled(control.info.getPlatform(), defaultName)) {
                this.usedNames.add(defaultName);
            }
            this.nameField.textProperty().addListener(o -> this.nameField.validate());
            this.nameField.validate();
            this.componentList.getContent().add((Object)namePane);
            String vendor = JavaInfo.normalizeVendor(control.info.getVendor());
            if (vendor != null) {
                this.addInfo(I18n.i18n("java.info.vendor"), vendor);
            }
            if (control.remoteVersion instanceof DiscoJavaRemoteVersion) {
                String distributionName = ((DiscoJavaRemoteVersion)control.remoteVersion).getDistribution();
                DiscoJavaDistribution distribution = DiscoJavaDistribution.of(distributionName);
                this.addInfo(I18n.i18n("java.info.disco.distribution"), distribution != null ? distribution.getDisplayName() : distributionName);
            } else {
                this.addInfo(I18n.i18n("java.install.archive"), control.file.toAbsolutePath().toString());
            }
            this.addInfo(I18n.i18n("java.info.version"), control.info.getVersion());
            this.addInfo(I18n.i18n("java.info.architecture"), control.info.getPlatform().getArchitecture().getDisplayName());
            BorderPane installPane = new BorderPane();
            JFXButton installButton = FXUtils.newRaisedButton(I18n.i18n("button.install"));
            installButton.setOnAction(e -> {
                String name = (String)control.nameProperty.get();
                if (JavaManager.REPOSITORY.isInstalled(control.info.getPlatform(), name)) {
                    Controllers.dialog(I18n.i18n("java.install.failed.exists"), null, MessageDialogPane.MessageType.WARNING);
                    this.usedNames.add(name);
                    this.nameField.validate();
                } else {
                    control.onFinish.run();
                }
            });
            installButton.disableProperty().bind((ObservableValue)this.nameField.activeValidatorProperty().isNotNull());
            installPane.setRight((Node)installButton);
            this.componentList.getContent().add((Object)installPane);
            borderPane.getChildren().setAll((Object[])new Node[]{this.componentList});
            this.getChildren().setAll((Object[])new Node[]{borderPane});
        }

        private void addInfo(String name, String value) {
            BorderPane pane = new BorderPane();
            pane.setLeft((Node)new Label(name));
            Label valueLabel = FXUtils.newSafeTruncatedLabel(value);
            FXUtils.copyOnDoubleClick((Labeled)valueLabel);
            BorderPane.setMargin((Node)valueLabel, (Insets)new Insets(0.0, 0.0, 0.0, 16.0));
            BorderPane.setAlignment((Node)valueLabel, (Pos)Pos.CENTER_RIGHT);
            pane.setCenter((Node)valueLabel);
            this.componentList.getContent().add((Object)pane);
        }
    }
}

