/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ToggleGroup;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.main.SettingsView;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.upgrade.UpdateChannel;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.Locales;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jackhuang.hmcl.util.logging.Logger;
import org.tukaani.xz.XZInputStream;

public final class SettingsPage
extends SettingsView {
    private InvalidationListener updateListener;

    public SettingsPage() {
        FXUtils.smoothScrolling(this.scroll);
        this.cboLanguage.getItems().setAll(Locales.LOCALES);
        ExtendedProperties.selectedItemPropertyFor(this.cboLanguage).bindBidirectional(ConfigHolder.config().localizationProperty());
        this.disableAutoGameOptionsPane.selectedProperty().bindBidirectional((Property)ConfigHolder.config().disableAutoGameOptionsProperty());
        this.fileCommonLocation.selectedDataProperty().bindBidirectional(ConfigHolder.config().commonDirTypeProperty());
        this.fileCommonLocationSublist.subtitleProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> Optional.ofNullable(Settings.instance().getCommonDirectory()).orElse(I18n.i18n("launcher.cache_directory.disabled")), (Observable[])new Observable[]{ConfigHolder.config().commonDirectoryProperty(), ConfigHolder.config().commonDirTypeProperty()}));
        FXUtils.installFastTooltip((Node)this.btnUpdate, I18n.i18n("update.tooltip"));
        this.updateListener = any -> {
            this.btnUpdate.setVisible(UpdateChecker.isOutdated());
            if (UpdateChecker.isOutdated()) {
                this.lblUpdateSub.setText(I18n.i18n("update.newest_version", UpdateChecker.getLatestVersion().getVersion()));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"update-label"});
                this.lblUpdate.setText(I18n.i18n("update.found"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[]{"update-label"});
            } else if (UpdateChecker.isCheckingUpdate()) {
                this.lblUpdateSub.setText(I18n.i18n("update.checking"));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"subtitle-label"});
                this.lblUpdate.setText(I18n.i18n("update"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[0]);
            } else {
                this.lblUpdateSub.setText(I18n.i18n("update.latest"));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"subtitle-label"});
                this.lblUpdate.setText(I18n.i18n("update"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[0]);
            }
        };
        UpdateChecker.latestVersionProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        UpdateChecker.outdatedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        UpdateChecker.checkingUpdateProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        this.updateListener.invalidated(null);
        ToggleGroup updateChannelGroup = new ToggleGroup();
        this.chkUpdateDev.setToggleGroup(updateChannelGroup);
        this.chkUpdateDev.setUserData((Object)UpdateChannel.DEVELOPMENT);
        this.chkUpdateStable.setToggleGroup(updateChannelGroup);
        this.chkUpdateStable.setUserData((Object)UpdateChannel.STABLE);
        ObjectProperty<UpdateChannel> updateChannel = ExtendedProperties.selectedItemPropertyFor(updateChannelGroup, UpdateChannel.class);
        updateChannel.set((Object)UpdateChannel.getChannel());
        updateChannel.addListener((a, b, newValue) -> UpdateChecker.requestCheckUpdate(newValue));
    }

    @Override
    protected void onUpdate() {
        RemoteVersion target = UpdateChecker.getLatestVersion();
        if (target == null) {
            return;
        }
        UpdateHandler.updateFrom(target);
    }

    private static boolean exportLogFile(ZipOutputStream output, Path file, String entryName, InputStream input, byte[] buffer) throws IOException {
        try {
            output.putNextEntry(new ZipEntry(entryName));
            while (true) {
                int read;
                try {
                    read = input.read(buffer);
                    if (read <= 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Throwable ex) {
                    Logger.LOG.warning("Failed to decompress log file " + file, ex);
                    boolean bl = false;
                    return bl;
                }
                output.write(buffer, 0, read);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Throwable ex) {
                Logger.LOG.warning("Failed to close log file " + file, ex);
            }
            output.closeEntry();
        }
    }

    @Override
    protected void onExportLogs() {
        Lang.thread(() -> {
            Path outputFile;
            block26: {
                String nameBase = "hmcl-exported-logs-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss"));
                List<Path> recentLogFiles = Logger.LOG.findRecentLogFiles(5);
                try {
                    if (recentLogFiles.isEmpty()) {
                        outputFile = Metadata.CURRENT_DIRECTORY.resolve(nameBase + ".log");
                        Logger.LOG.info("Exporting latest logs to " + outputFile);
                        try (OutputStream output = Files.newOutputStream(outputFile, new OpenOption[0]);){
                            Logger.LOG.exportLogs(output);
                            break block26;
                        }
                    }
                    outputFile = Metadata.CURRENT_DIRECTORY.resolve(nameBase + ".zip");
                    Logger.LOG.info("Exporting latest logs to " + outputFile);
                    byte[] buffer = new byte[8192];
                    try (OutputStream os = Files.newOutputStream(outputFile, new OpenOption[0]);
                         ZipOutputStream zos = new ZipOutputStream(os);){
                        for (Path path : recentLogFiles) {
                            InputStream input;
                            String fileName = FileUtils.getName(path);
                            String extension = StringUtils.substringAfterLast(fileName, '.');
                            if ("gz".equals(extension) || "xz".equals(extension)) {
                                input = null;
                                try {
                                    input = Files.newInputStream(path, new OpenOption[0]);
                                    input = "gz".equals(extension) ? new GZIPInputStream(input) : new XZInputStream(input);
                                }
                                catch (Throwable ex) {
                                    Logger.LOG.warning("Failed to open log file " + path, ex);
                                    IOUtils.closeQuietly(input, ex);
                                    input = null;
                                }
                                String entryName = StringUtils.substringBeforeLast(fileName, ".");
                                if (input != null && SettingsPage.exportLogFile(zos, path, entryName, input, buffer)) continue;
                            }
                            try {
                                input = Files.newInputStream(path, new OpenOption[0]);
                            }
                            catch (Throwable ex) {
                                Logger.LOG.warning("Failed to open log file " + path, ex);
                                continue;
                            }
                            SettingsPage.exportLogFile(zos, path, fileName, input, buffer);
                        }
                        zos.putNextEntry(new ZipEntry("hmcl-latest.log"));
                        Logger.LOG.exportLogs(zos);
                        zos.closeEntry();
                    }
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to export logs", e);
                    Platform.runLater(() -> Controllers.dialog(I18n.i18n("settings.launcher.launcher_log.export.failed") + "\n" + StringUtils.getStackTrace(e), null, MessageDialogPane.MessageType.ERROR));
                    return;
                }
            }
            Platform.runLater(() -> Controllers.dialog(I18n.i18n("settings.launcher.launcher_log.export.success", outputFile)));
            FXUtils.showFileInExplorer(outputFile);
        });
    }

    @Override
    protected void onSponsor() {
        FXUtils.openLink("https://github.com/HMCL-dev/HMCL");
    }

    @Override
    protected void clearCacheDirectory() {
        String commonDirectory = Settings.instance().getCommonDirectory();
        if (commonDirectory != null) {
            FileUtils.cleanDirectoryQuietly(Path.of(commonDirectory, "cache"));
        }
    }
}

