/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.mod.Datapack;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.versions.DatapackListPageSkin;
import org.jackhuang.hmcl.ui.versions.WorldManagePage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;
import org.jackhuang.hmcl.util.logging.Logger;

public final class DatapackListPage
extends ListPageBase<DatapackListPageSkin.DatapackInfoObject> {
    private final Path worldDir;
    private final Datapack datapack;

    public DatapackListPage(WorldManagePage worldManagePage) {
        this.worldDir = worldManagePage.getWorld().getFile();
        this.datapack = new Datapack(this.worldDir.resolve("datapacks"));
        this.datapack.loadFromDir();
        this.setItems(MappedObservableList.create(this.datapack.getInfo(), DatapackListPageSkin.DatapackInfoObject::new));
        FXUtils.applyDragListener((Node)this, it -> Objects.equals("zip", FileUtils.getExtension(it)), mods -> mods.forEach(this::installSingleDatapack), this::refresh);
    }

    private void installSingleDatapack(Path datapack) {
        try {
            Datapack zip = new Datapack(datapack);
            zip.loadFromZip();
            zip.installTo(this.worldDir);
        }
        catch (IOException | IllegalArgumentException e) {
            Logger.LOG.warning("Unable to parse datapack file " + datapack, e);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new DatapackListPageSkin(this);
    }

    public void refresh() {
        this.setLoading(true);
        Task.runAsync(this.datapack::loadFromDir).withRunAsync(Schedulers.javafx(), () -> this.setLoading(false)).start();
    }

    public void add() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("datapack.choose_datapack"));
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18n.i18n("datapack.extension"), new String[]{"*.zip"})});
        List<Path> res = FileUtils.toPaths(chooser.showOpenMultipleDialog((Window)Controllers.getStage()));
        if (res != null) {
            res.forEach(this::installSingleDatapack);
        }
        this.datapack.loadFromDir();
    }

    void removeSelected(ObservableList<DatapackListPageSkin.DatapackInfoObject> selectedItems) {
        selectedItems.stream().map(DatapackListPageSkin.DatapackInfoObject::getPackInfo).forEach(pack -> {
            try {
                this.datapack.deletePack((Datapack.Pack)pack);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to delete datapack " + pack);
            }
        });
    }

    void enableSelected(ObservableList<DatapackListPageSkin.DatapackInfoObject> selectedItems) {
        selectedItems.stream().map(DatapackListPageSkin.DatapackInfoObject::getPackInfo).forEach(info -> info.setActive(true));
    }

    void disableSelected(ObservableList<DatapackListPageSkin.DatapackInfoObject> selectedItems) {
        selectedItems.stream().map(DatapackListPageSkin.DatapackInfoObject::getPackInfo).forEach(info -> info.setActive(false));
    }
}

