/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.task.Task;

public class ModCheckUpdatesTask
extends Task<List<LocalModFile.ModUpdate>> {
    private final String gameVersion;
    private final Collection<LocalModFile> mods;
    private final Collection<Collection<Task<LocalModFile.ModUpdate>>> dependents;

    public ModCheckUpdatesTask(String gameVersion, Collection<LocalModFile> mods) {
        this.gameVersion = gameVersion;
        this.mods = mods;
        this.dependents = mods.stream().map(mod -> Arrays.stream(RemoteMod.Type.values()).map(type -> Task.supplyAsync(() -> mod.checkUpdates(gameVersion, type.getRemoteModRepository())).setSignificance(Task.TaskSignificance.MAJOR).setName(String.format("%s (%s)", mod.getFileName(), type.name())).withCounter("mods.check_updates")).collect(Collectors.toList())).collect(Collectors.toList());
        this.setStage("mods.check_updates");
        this.getProperties().put("total", this.dependents.size() * RemoteMod.Type.values().length);
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() {
        this.notifyPropertiesChanged();
    }

    @Override
    public Collection<? extends Task<?>> getDependents() {
        return this.dependents.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean isRelyingOnDependents() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        this.setResult(this.dependents.stream().map(tasks -> tasks.stream().filter(task -> task.getResult() != null).map(Task::getResult).filter(modUpdate -> !modUpdate.getCandidates().isEmpty()).max(Comparator.comparing(modUpdate -> modUpdate.getCandidates().get(0).getDatePublished())).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

