/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.wizard;

import java.util.Queue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.construct.TaskListPane;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.WizardDisplayer;
import org.jackhuang.hmcl.util.SettingsMap;

public abstract class AbstractWizardDisplayer
implements WizardDisplayer {
    private final Queue<Object> cancelQueue;

    public AbstractWizardDisplayer(Queue<Object> cancelQueue) {
        this.cancelQueue = cancelQueue;
    }

    @Override
    public void handleTask(SettingsMap settings, Task<?> task) {
        TaskExecutor executor = task.withRunAsync(Schedulers.javafx(), this::navigateToSuccess).executor();
        TaskListPane pane = new TaskListPane();
        pane.setExecutor(executor);
        this.navigateTo((Node)pane, Navigation.NavigationDirection.FINISH);
        this.cancelQueue.add(executor);
        executor.start();
    }

    @Override
    public void onCancel() {
        while (!this.cancelQueue.isEmpty()) {
            Object x = this.cancelQueue.poll();
            if (x instanceof TaskExecutor) {
                ((TaskExecutor)x).cancel();
                continue;
            }
            if (x instanceof Thread) {
                ((Thread)x).interrupt();
                continue;
            }
            throw new IllegalStateException("Unrecognized cancel queue element: " + x);
        }
    }

    void navigateToSuccess() {
        this.navigateTo((Node)new Label("Successful"), Navigation.NavigationDirection.FINISH);
    }
}

