/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.jackhuang.hmcl.EntryPoint;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.JavaFXPatcher;
import org.jackhuang.hmcl.util.SwingUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Platform;

public final class SelfDependencyPatcher {
    private final List<DependencyDescriptor> dependencies = DependencyDescriptor.readDependencies();
    private final List<Repository> repositories;
    private final Repository defaultRepository;
    private final byte[] buffer = new byte[8192];
    private final MessageDigest digest = DigestUtils.getDigest("SHA-1");

    private SelfDependencyPatcher() throws IncompatibleVersionException {
        if (this.dependencies == null) {
            throw new IncompatibleVersionException();
        }
        String customUrl = System.getProperty("hmcl.openjfx.repo");
        if (customUrl == null) {
            this.defaultRepository = System.getProperty("user.country", "").equalsIgnoreCase("CN") ? Repository.TENCENTCLOUD_MIRROR : Repository.MAVEN_CENTRAL;
            this.repositories = List.of(Repository.MAVEN_CENTRAL, Repository.TENCENTCLOUD_MIRROR);
        } else {
            this.defaultRepository = new Repository(String.format(I18n.i18n("repositories.custom"), customUrl), customUrl);
            this.repositories = List.of(Repository.MAVEN_CENTRAL, Repository.TENCENTCLOUD_MIRROR, this.defaultRepository);
        }
    }

    public static void patch() throws PatchException, IncompatibleVersionException, CancellationException {
        try {
            Class.forName("javafx.application.Application");
            return;
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError error) {
            throw new IncompatibleVersionException();
        }
        SelfDependencyPatcher patcher = new SelfDependencyPatcher();
        Logger.LOG.info("Missing JavaFX dependencies, attempting to patch in missing classes");
        List<DependencyDescriptor> missingDependencies = patcher.checkMissingDependencies();
        if (!missingDependencies.isEmpty()) {
            try {
                patcher.fetchDependencies(missingDependencies);
            }
            catch (IOException e) {
                throw new PatchException("Failed to download dependencies", e);
            }
        }
        try {
            patcher.loadFromCache();
        }
        catch (IOException ex) {
            throw new PatchException("Failed to load JavaFX cache", ex);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException ex) {
            throw new PatchException("Failed to add dependencies to classpath!", ex);
        }
        Logger.LOG.info(" - Done!");
    }

    private Repository showChooseRepositoryDialog() {
        AbstractButton button;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (String line : I18n.i18n("repositories.chooser").split("\n")) {
            panel.add(new JLabel(line));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Repository repository : this.repositories) {
            button = new JRadioButton(repository.name);
            button.putClientProperty("repository", repository);
            buttonGroup.add(button);
            panel.add(button);
            if (repository != this.defaultRepository) continue;
            button.setSelected(true);
        }
        int res = JOptionPane.showConfirmDialog(null, panel, I18n.i18n("repositories.chooser.title"), 2);
        if (res == 0) {
            Enumeration<AbstractButton> buttons = buttonGroup.getElements();
            while (buttons.hasMoreElements()) {
                button = buttons.nextElement();
                if (!button.isSelected()) continue;
                return (Repository)button.getClientProperty("repository");
            }
        } else {
            Logger.LOG.info("User choose not to download JavaFX");
            EntryPoint.exit(0);
        }
        throw new AssertionError();
    }

    private void loadFromCache() throws IOException, ReflectiveOperationException {
        Logger.LOG.info(" - Loading dependencies...");
        Set<String> modules = this.dependencies.stream().map(it -> it.module).collect(Collectors.toSet());
        Path[] jars = (Path[])this.dependencies.stream().map(DependencyDescriptor::localPath).toArray(Path[]::new);
        String addOpens = null;
        try (InputStream input = SelfDependencyPatcher.class.getResourceAsStream("/META-INF/MANIFEST.MF");){
            if (input != null) {
                addOpens = new Manifest(input).getMainAttributes().getValue("Add-Opens");
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to read MANIFEST.MF file", e);
        }
        JavaFXPatcher.patch(modules, jars, addOpens != null ? addOpens.split(" ") : new String[]{});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchDependencies(List<DependencyDescriptor> dependencies) throws IOException {
        ProgressFrame dialog;
        SwingUtils.initLookAndFeel();
        boolean isFirstTime = true;
        Repository repository = this.defaultRepository;
        int count = 0;
        while (true) {
            AtomicBoolean isCancelled = new AtomicBoolean();
            AtomicBoolean showDetails = new AtomicBoolean();
            dialog = new ProgressFrame(I18n.i18n("download.javafx"));
            dialog.setProgressMaximum(dependencies.size() + 1);
            dialog.setProgress(count);
            dialog.setOnCancel(() -> isCancelled.set(true));
            dialog.setOnChangeSource(() -> {
                isCancelled.set(true);
                showDetails.set(true);
            });
            dialog.setVisible(true);
            try {
                if (isFirstTime) {
                    isFirstTime = false;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Files.createDirectories(DependencyDescriptor.DEPENDENCIES_DIR_PATH, new FileAttribute[0]);
                for (int i = count; i < dependencies.size(); ++i) {
                    if (isCancelled.get()) {
                        throw new CancellationException();
                    }
                    DependencyDescriptor dependency = dependencies.get(i);
                    String url = repository.resolveDependencyURL(dependency);
                    SwingUtilities.invokeLater(() -> {
                        dialog.setCurrent(dependency.module);
                        dialog.incrementProgress();
                    });
                    Logger.LOG.info("Downloading " + url);
                    try (InputStream is = new URL(url).openStream();
                         OutputStream os = Files.newOutputStream(dependency.localPath(), new OpenOption[0]);){
                        int read;
                        while ((read = is.read(this.buffer, 0, 8192)) >= 0) {
                            if (isCancelled.get()) {
                                try {
                                    os.close();
                                }
                                finally {
                                    Files.deleteIfExists(dependency.localPath());
                                }
                                throw new CancellationException();
                            }
                            os.write(this.buffer, 0, read);
                        }
                    }
                    this.verifyChecksum(dependency);
                    ++count;
                }
            }
            catch (CancellationException e) {
                dialog.dispose();
                if (showDetails.get()) {
                    repository = this.showChooseRepositoryDialog();
                    continue;
                }
                throw e;
            }
            break;
        }
        dialog.dispose();
    }

    private List<DependencyDescriptor> checkMissingDependencies() {
        ArrayList<DependencyDescriptor> missing = new ArrayList<DependencyDescriptor>();
        for (DependencyDescriptor dependency : this.dependencies) {
            if (!Files.exists(dependency.localPath(), new LinkOption[0])) {
                missing.add(dependency);
                continue;
            }
            try {
                this.verifyChecksum(dependency);
            }
            catch (ChecksumMismatchException e) {
                Logger.LOG.warning("Corrupted dependency " + dependency.filename() + ": " + e.getMessage());
                missing.add(dependency);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return missing;
    }

    private void verifyChecksum(DependencyDescriptor dependency) throws IOException, ChecksumMismatchException {
        this.digest.reset();
        try (InputStream is = Files.newInputStream(dependency.localPath(), new OpenOption[0]);){
            int read;
            while ((read = is.read(this.buffer, 0, 8192)) > -1) {
                this.digest.update(this.buffer, 0, read);
            }
        }
        String sha1 = HexFormat.of().formatHex(this.digest.digest());
        if (!dependency.sha1().equalsIgnoreCase(sha1)) {
            throw new ChecksumMismatchException("SHA-1", dependency.sha1(), sha1);
        }
    }

    private static final class DependencyDescriptor {
        private static final String DEPENDENCIES_LIST_FILE = "/assets/openjfx-dependencies.json";
        private static final Path DEPENDENCIES_DIR_PATH = Metadata.DEPENDENCIES_DIRECTORY.resolve(Platform.getPlatform().toString()).resolve("openjfx");
        public String module;
        public String groupId;
        public String artifactId;
        public String version;
        public String classifier;
        public String sha1;

        private DependencyDescriptor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static List<DependencyDescriptor> readDependencies() {
            try (InputStreamReader reader = new InputStreamReader(SelfDependencyPatcher.class.getResourceAsStream(DEPENDENCIES_LIST_FILE), StandardCharsets.UTF_8);){
                List<DependencyDescriptor> modernDependencies;
                Map<String, Map<String, List<DependencyDescriptor>>> allDependencies = JsonUtils.GSON.fromJson((Reader)reader, JsonUtils.mapTypeOf(String.class, JsonUtils.mapTypeOf(String.class, JsonUtils.listTypeOf(DependencyDescriptor.class))));
                Map<String, List<DependencyDescriptor>> platform = allDependencies.get(Platform.getPlatform().toString());
                if (platform == null) {
                    List<DependencyDescriptor> list = null;
                    return list;
                }
                if (JavaRuntime.CURRENT_VERSION >= 23 && (modernDependencies = platform.get("modern")) != null) {
                    List<DependencyDescriptor> list = modernDependencies;
                    return list;
                }
                List<DependencyDescriptor> list = platform.get("classic");
                return list;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public String filename() {
            return this.artifactId + "-" + this.version + "-" + this.classifier + ".jar";
        }

        public String sha1() {
            return this.sha1;
        }

        public Path localPath() {
            return DEPENDENCIES_DIR_PATH.resolve(this.filename());
        }
    }

    public static class IncompatibleVersionException
    extends Exception {
    }

    private record Repository(String name, String url) {
        public static final Repository MAVEN_CENTRAL = new Repository(I18n.i18n("repositories.maven_central"), "https://repo1.maven.org/maven2");
        public static final Repository TENCENTCLOUD_MIRROR = new Repository(I18n.i18n("repositories.tencentcloud_mirror"), "https://mirrors.cloud.tencent.com/nexus/repository/maven-public");

        public String resolveDependencyURL(DependencyDescriptor descriptor) {
            return String.format("%s/%s/%s/%s/%s", this.url, descriptor.groupId.replace('.', '/'), descriptor.artifactId, descriptor.version, descriptor.filename());
        }
    }

    public static class PatchException
    extends Exception {
        PatchException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ProgressFrame
    extends JDialog {
        private final JProgressBar progressBar;
        private final JLabel progressText;
        private final JButton btnChangeSource;
        private final JButton btnCancel;

        public ProgressFrame(String title) {
            JPanel panel = new JPanel();
            this.setResizable(false);
            this.setTitle(title);
            this.setDefaultCloseOperation(2);
            this.setBounds(100, 100, 500, 200);
            this.setContentPane(panel);
            this.setLocationRelativeTo(null);
            JPanel content = new JPanel();
            content.setLayout(new BoxLayout(content, 1));
            for (String note : I18n.i18n("download.javafx.notes").split("\n")) {
                content.add(new JLabel(note));
            }
            content.add(new JLabel("<html><br/></html>"));
            this.progressText = new JLabel(I18n.i18n("download.javafx.prepare"));
            content.add(this.progressText);
            this.progressBar = new JProgressBar();
            content.add(this.progressBar);
            JPanel buttonBar = new JPanel();
            this.btnChangeSource = new JButton(I18n.i18n("button.change_source"));
            this.btnCancel = new JButton(I18n.i18n("button.cancel"));
            buttonBar.add(this.btnChangeSource);
            buttonBar.add(this.btnCancel);
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
            panel.add((Component)content, "Center");
            panel.add((Component)buttonBar, "South");
        }

        public void setCurrent(String component) {
            this.progressText.setText(I18n.i18n("download.javafx.component", component));
        }

        public void setProgressMaximum(int total) {
            this.progressBar.setMaximum(total);
        }

        public void setProgress(int n) {
            this.progressBar.setValue(n);
        }

        public void incrementProgress() {
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        }

        public void setOnCancel(final Runnable action) {
            this.btnCancel.addActionListener(e -> action.run());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    action.run();
                }
            });
        }

        public void setOnChangeSource(Runnable action) {
            this.btnChangeSource.addActionListener(e -> action.run());
        }
    }
}

