/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;

public class DefaultResourceBundleControl
extends ResourceBundle.Control {
    public static final DefaultResourceBundleControl INSTANCE = new DefaultResourceBundleControl();

    private static List<Locale> ensureEditable(List<Locale> list) {
        return list instanceof ArrayList ? list : new ArrayList(list);
    }

    @Override
    public List<Locale> getCandidateLocales(String baseName, Locale locale) {
        String script;
        if (locale.getLanguage().isEmpty()) {
            return this.getCandidateLocales(baseName, Locale.ENGLISH);
        }
        if (LocaleUtils.isChinese(locale) && (script = locale.getScript()).isEmpty() && !(script = LocaleUtils.getScript(locale)).isEmpty()) {
            return this.getCandidateLocales(baseName, new Locale.Builder().setLocale(locale).setScript(script).build());
        }
        String language = locale.getLanguage();
        List<Locale> locales = super.getCandidateLocales(baseName, locale);
        if (language.length() == 3) {
            String iso1 = LocaleUtils.toISO1Language(locale.getLanguage());
            if (iso1.length() == 2) {
                locales = DefaultResourceBundleControl.ensureEditable(locales);
                locales.removeIf(it -> !it.getLanguage().equals(language));
                locales.addAll(this.getCandidateLocales(baseName, new Locale.Builder().setLocale(locale).setLanguage(iso1).build()));
            }
        } else if (language.equals("zh")) {
            int chineseIdx;
            if (locales.contains(LocaleUtils.LOCALE_ZH_HANT) && !locales.contains(Locale.TRADITIONAL_CHINESE) && (chineseIdx = (locales = DefaultResourceBundleControl.ensureEditable(locales)).indexOf(Locale.CHINESE)) >= 0) {
                locales.add(chineseIdx, Locale.TRADITIONAL_CHINESE);
            }
            if (!locales.contains(Locale.SIMPLIFIED_CHINESE) && (chineseIdx = locales.indexOf(Locale.CHINESE)) >= 0) {
                if ((locales = DefaultResourceBundleControl.ensureEditable(locales)).contains(LocaleUtils.LOCALE_ZH_HANS)) {
                    locales.add(chineseIdx, Locale.SIMPLIFIED_CHINESE);
                } else {
                    locales.add(chineseIdx + 1, Locale.SIMPLIFIED_CHINESE);
                }
            }
        }
        return locales;
    }
}

