/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.DefaultResourceBundleControl;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class LocaleUtils {
    public static final Locale SYSTEM_DEFAULT = Locale.getDefault();
    public static final Locale LOCALE_ZH_HANS = Locale.forLanguageTag("zh-Hans");
    public static final Locale LOCALE_ZH_HANT = Locale.forLanguageTag("zh-Hant");
    public static final String DEFAULT_LANGUAGE_KEY = "default";
    public static final Set<String> CHINESE_TRADITIONAL_REGIONS = Set.of("TW", "HK", "MO");
    public static final Set<String> CHINESE_LATN_VARIANTS = Set.of("pinyin", "wadegile", "tongyong");

    public static String toLanguageKey(Locale locale) {
        return locale.getLanguage().isEmpty() ? DEFAULT_LANGUAGE_KEY : locale.stripExtensions().toLanguageTag();
    }

    public static boolean isISO1Language(String language) {
        return language.length() == 2;
    }

    public static boolean isISO3Language(String language) {
        return language.length() == 3;
    }

    @NotNull
    public static String getISO1Language(Locale locale) {
        String language = locale.getLanguage();
        if (language.isEmpty()) {
            return "en";
        }
        return LocaleUtils.isISO3Language(language) ? LocaleUtils.toISO1Language(language) : language;
    }

    @NotNull
    public static String getScript(Locale locale) {
        if (locale.getScript().isEmpty() && LocaleUtils.isChinese(locale)) {
            if (CHINESE_LATN_VARIANTS.contains(locale.getVariant())) {
                return "Latn";
            }
            if (locale.getLanguage().equals("lzh") || CHINESE_TRADITIONAL_REGIONS.contains(locale.getCountry())) {
                return "Hant";
            }
            return "Hans";
        }
        return locale.getScript();
    }

    @NotNull
    public static List<Locale> getCandidateLocales(Locale locale) {
        return DefaultResourceBundleControl.INSTANCE.getCandidateLocales("", locale);
    }

    @Nullable
    public static <T> T getByCandidateLocales(Map<String, T> map, List<Locale> candidateLocales) {
        for (Locale locale : candidateLocales) {
            String key = LocaleUtils.toLanguageKey(locale);
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    @NotNull
    public static @Unmodifiable Map<String, Path> findAllLocalizedFiles(Path dir, String baseName, String ext) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            LinkedHashMap<String, Path> linkedHashMap;
            block9: {
                String suffix = "." + ext;
                String defaultName = baseName + suffix;
                String noDefaultPrefix = baseName + "_";
                Stream<Path> list = Files.list(dir);
                try {
                    LinkedHashMap<String, Path> result = new LinkedHashMap<String, Path>();
                    list.forEach(file -> {
                        if (Files.isRegularFile(file, new LinkOption[0])) {
                            String languageKey;
                            String fileName = file.getFileName().toString();
                            if (fileName.equals(defaultName)) {
                                result.put(DEFAULT_LANGUAGE_KEY, (Path)file);
                            } else if (fileName.startsWith(noDefaultPrefix) && fileName.endsWith(suffix) && !(languageKey = fileName.substring(noDefaultPrefix.length(), fileName.length() - suffix.length()).replace('_', '-')).isEmpty()) {
                                result.put(languageKey, (Path)file);
                            }
                        }
                    });
                    linkedHashMap = result;
                    if (list == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (list != null) {
                            try {
                                list.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to list files in directory " + dir, e);
                    }
                }
                list.close();
            }
            return linkedHashMap;
        }
        return Map.of();
    }

    @NotNull
    public static @Unmodifiable Map<String, Map<String, Path>> findAllLocalizedFiles(Path dir, String baseName, Collection<String> exts) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            LinkedHashMap<String, Map<String, Path>> linkedHashMap;
            block9: {
                Stream<Path> list = Files.list(dir);
                try {
                    LinkedHashMap<String, Map<String, Path>> result = new LinkedHashMap<String, Map<String, Path>>();
                    list.forEach(file -> {
                        if (Files.isRegularFile(file, new LinkOption[0])) {
                            String languageKey;
                            String fileName = file.getFileName().toString();
                            if (!fileName.startsWith(baseName)) {
                                return;
                            }
                            String ext = StringUtils.substringAfterLast(fileName, '.');
                            if (!exts.contains(ext)) {
                                return;
                            }
                            int defaultFileNameLength = baseName.length() + ext.length() + 1;
                            if (fileName.length() == defaultFileNameLength) {
                                languageKey = DEFAULT_LANGUAGE_KEY;
                            } else if (fileName.length() > defaultFileNameLength + 1 && fileName.charAt(baseName.length()) == '_') {
                                languageKey = fileName.substring(baseName.length() + 1, fileName.length() - ext.length() - 1).replace('_', '-');
                            } else {
                                return;
                            }
                            result.computeIfAbsent(languageKey, key -> new HashMap()).put(ext, file);
                        }
                    });
                    linkedHashMap = result;
                    if (list == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (list != null) {
                            try {
                                list.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Failed to list files in directory " + dir, e);
                    }
                }
                list.close();
            }
            return linkedHashMap;
        }
        return Map.of();
    }

    public static String toISO1Language(String languageTag) {
        return switch (languageTag) {
            case "eng" -> "en";
            case "spa" -> "es";
            case "jpa" -> "ja";
            case "rus" -> "ru";
            case "ukr" -> "uk";
            case "zho", "cmn", "lzh", "cdo", "cjy", "cpx", "czh", "gan", "hak", "hsn", "mnp", "nan", "wuu", "yue" -> "zh";
            default -> languageTag;
        };
    }

    public static boolean isEnglish(Locale locale) {
        return "en".equals(LocaleUtils.getISO1Language(locale));
    }

    public static boolean isChinese(Locale locale) {
        return "zh".equals(LocaleUtils.getISO1Language(locale));
    }

    private LocaleUtils() {
    }
}

