/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.DefaultResourceBundleControl;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.i18n.WenyanUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class Locales {
    public static final SupportedLocale DEFAULT;
    public static final SupportedLocale EN;
    public static final SupportedLocale ES;
    public static final SupportedLocale RU;
    public static final SupportedLocale UK;
    public static final SupportedLocale JA;
    public static final SupportedLocale ZH_HANS;
    public static final SupportedLocale ZH_HANT;
    public static final SupportedLocale WENYAN;
    public static final List<SupportedLocale> LOCALES;

    private Locales() {
    }

    public static SupportedLocale getLocaleByName(String name) {
        if (name == null) {
            return DEFAULT;
        }
        for (SupportedLocale locale : LOCALES) {
            if (!locale.getName().equalsIgnoreCase(name)) continue;
            return locale;
        }
        return DEFAULT;
    }

    static {
        String language = System.getenv("HMCL_LANGUAGE");
        DEFAULT = new SupportedLocale(true, "def", StringUtils.isBlank(language) ? LocaleUtils.SYSTEM_DEFAULT : Locale.forLanguageTag(language));
        EN = new SupportedLocale("en");
        ES = new SupportedLocale("es");
        RU = new SupportedLocale("ru");
        UK = new SupportedLocale("uk");
        JA = new SupportedLocale("ja");
        ZH_HANS = new SupportedLocale("zh_CN", LocaleUtils.LOCALE_ZH_HANS);
        ZH_HANT = new SupportedLocale("zh", LocaleUtils.LOCALE_ZH_HANT);
        WENYAN = new SupportedLocale("lzh");
        LOCALES = List.of(DEFAULT, EN, ES, JA, RU, UK, ZH_HANS, ZH_HANT, WENYAN);
    }

    @JsonAdapter(value=TypeAdapter.class)
    public static final class SupportedLocale {
        private final boolean isDefault;
        private final String name;
        private final Locale locale;
        private ResourceBundle resourceBundle;
        private DateTimeFormatter dateTimeFormatter;
        private List<Locale> candidateLocales;

        SupportedLocale(boolean isDefault, String name, Locale locale) {
            this.isDefault = isDefault;
            this.name = name;
            this.locale = locale;
        }

        SupportedLocale(String name) {
            this(false, name, Locale.forLanguageTag(name));
        }

        SupportedLocale(String name, Locale locale) {
            this(false, name, locale);
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String getName() {
            return this.name;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getDisplayName(SupportedLocale inLocale) {
            String iso1;
            if (this.isDefault()) {
                try {
                    return inLocale.getResourceBundle().getString("lang.default");
                }
                catch (Throwable e) {
                    Logger.LOG.warning("Failed to get localized name for default locale", e);
                    return "Default";
                }
            }
            Locale inJavaLocale = inLocale.getLocale();
            if (LocaleUtils.isISO3Language(inJavaLocale.getLanguage()) && LocaleUtils.isISO1Language(iso1 = LocaleUtils.getISO1Language(inJavaLocale))) {
                Locale.Builder builder = new Locale.Builder().setLocale(inJavaLocale).setLanguage(iso1);
                if (inJavaLocale.getScript().isEmpty()) {
                    builder.setScript(LocaleUtils.getScript(inJavaLocale));
                }
                inJavaLocale = builder.build();
            }
            if (this.locale.getLanguage().equals("lzh")) {
                if (inJavaLocale.getLanguage().equals("zh")) {
                    return "\u6587\u8a00";
                }
                String name = this.locale.getDisplayName(inJavaLocale);
                return name.equals("lzh") || name.equals("Literary Chinese") ? "Chinese (Classical)" : name;
            }
            return this.locale.getDisplayName(inJavaLocale);
        }

        public ResourceBundle getResourceBundle() {
            ResourceBundle bundle = this.resourceBundle;
            if (this.resourceBundle == null) {
                this.resourceBundle = bundle = ResourceBundle.getBundle("assets.lang.I18N", this.locale, DefaultResourceBundleControl.INSTANCE);
            }
            return bundle;
        }

        public List<Locale> getCandidateLocales() {
            if (this.candidateLocales == null) {
                this.candidateLocales = List.copyOf(LocaleUtils.getCandidateLocales(this.locale));
            }
            return this.candidateLocales;
        }

        public String i18n(String key, Object ... formatArgs) {
            try {
                return String.format(this.getResourceBundle().getString(key), formatArgs);
            }
            catch (MissingResourceException e) {
                Logger.LOG.error("Cannot find key " + key + " in resource bundle", e);
            }
            catch (IllegalFormatException e) {
                Logger.LOG.error("Illegal format string, key=" + key + ", args=" + Arrays.toString(formatArgs), e);
            }
            return key + Arrays.toString(formatArgs);
        }

        public String i18n(String key) {
            try {
                return this.getResourceBundle().getString(key);
            }
            catch (MissingResourceException e) {
                Logger.LOG.error("Cannot find key " + key + " in resource bundle", e);
                return key;
            }
        }

        public String formatDateTime(TemporalAccessor time) {
            DateTimeFormatter formatter = this.dateTimeFormatter;
            if (formatter == null) {
                if (this.locale.getLanguage().equals("lzh")) {
                    return WenyanUtils.formatDateTime(time);
                }
                formatter = this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.getResourceBundle().getString("datetime.format")).withZone(ZoneId.systemDefault());
            }
            return formatter.format(time);
        }

        public String getFcMatchPattern() {
            String language = this.locale.getLanguage();
            String region = this.locale.getCountry();
            if (LocaleUtils.isEnglish(this.locale)) {
                return "";
            }
            if (LocaleUtils.isChinese(this.locale)) {
                String charset;
                String lang;
                String script;
                switch (script = LocaleUtils.getScript(this.locale)) {
                    case "Hans": {
                        lang = region.equals("SG") || region.equals("MY") ? "zh-" + region : "zh-CN";
                        charset = "0x6e38,0x620f";
                        break;
                    }
                    case "Hant": {
                        lang = region.equals("HK") || region.equals("MO") ? "zh-" + region : "zh-TW";
                        charset = "0x904a,0x6232";
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                return ":lang=" + lang + ":charset=" + charset;
            }
            return region.isEmpty() ? language : language + "-" + region;
        }

        public boolean isSameLanguage(SupportedLocale other) {
            return LocaleUtils.getISO1Language(this.getLocale()).equals(LocaleUtils.getISO1Language(other.getLocale()));
        }

        public static final class TypeAdapter
        extends com.google.gson.TypeAdapter<SupportedLocale> {
            @Override
            public void write(JsonWriter out, SupportedLocale value) throws IOException {
                out.value(value.getName());
            }

            @Override
            public SupportedLocale read(JsonReader in) throws IOException {
                return Locales.getLocaleByName(in.nextString());
            }
        }
    }
}

