/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ContentEncoding {
    IDENTITY{

        @Override
        public InputStream wrap(InputStream inputStream) {
            return inputStream;
        }
    }
    ,
    GZIP{

        @Override
        public InputStream wrap(InputStream inputStream) throws IOException {
            return new GZIPInputStream(inputStream);
        }
    };


    @NotNull
    public static ContentEncoding fromConnection(URLConnection connection) throws IOException {
        String encoding = connection.getContentEncoding();
        if (encoding == null || encoding.isEmpty() || "identity".equals(encoding)) {
            return IDENTITY;
        }
        if ("gzip".equalsIgnoreCase(encoding)) {
            return GZIP;
        }
        throw new IOException("Unsupported content encoding: " + encoding);
    }

    public abstract InputStream wrap(InputStream var1) throws IOException;
}

