/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.hardware;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.platform.hardware.HardwareVendor;
import org.jetbrains.annotations.Nullable;

public final class CentralProcessor {
    private final String name;
    @Nullable
    private final HardwareVendor vendor;
    @Nullable
    private final Cores cores;

    public static String cleanName(String name) {
        if (name == null) {
            return null;
        }
        int idx = ((String)name).indexOf(64);
        if (idx > 0) {
            name = ((String)name).substring(0, idx);
        }
        name = ((String)name).replaceFirst(" (\\d+|Dual|Quad|Six|Eight|Ten)-[Cc]ores?", "");
        name = ((String)name).replaceAll(" (CPU|FPU|APU|Processor)", "");
        if (((String)(name = ((String)name).replaceAll("\\((TM|R)\\)(?=\\s|$)", ""))).contains("Intel")) {
            name = ((String)name).replaceFirst("^(\\d+th Gen )?Intel\\s+", "Intel ");
            name = ((String)name).replace("Core(TM)2", "Core 2");
        } else if (((String)name).contains("AMD")) {
            idx = ((String)(name = ((String)name).replace("(tm)", ""))).indexOf(" w/ Radeon ");
            if (idx < 0) {
                idx = ((String)name).indexOf(" with Radeon ");
            }
            if (idx < 0) {
                idx = ((String)name).indexOf(" with AMD Radeon ");
            }
            if (idx > 0) {
                name = ((String)name).substring(0, idx);
            }
        } else if (((String)name).contains("Loongson")) {
            name = ((String)name).replaceFirst("^Loongson-3A R\\d \\((Loongson-[^)]+)\\)", "$1");
        } else if (((String)name).contains("Snapdragon") && ((String)(name = StringUtils.normalizeWhitespaces((String)name))).startsWith("Snapdragon ")) {
            Matcher matcher = Pattern.compile("Snapdragon X Elite - (?<id>X1E\\S+) - Qualcomm Oryon").matcher((CharSequence)name);
            if (matcher.matches()) {
                name = "Qualcomm Snapdragon X Elite " + matcher.group("id");
            } else if (!((String)name).contains("Qualcomm")) {
                name = "Qualcomm " + (String)name;
            }
        }
        return StringUtils.normalizeWhitespaces((String)name);
    }

    private CentralProcessor(String name, @Nullable HardwareVendor vendor, @Nullable Cores cores) {
        this.name = name;
        this.vendor = vendor;
        this.cores = cores;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public HardwareVendor getVendor() {
        return this.vendor;
    }

    @Nullable
    public Cores getCores() {
        return this.cores;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        if (this.cores != null && this.cores.packages > 1) {
            builder.append(this.cores.packages).append(" x ");
        }
        builder.append(this.name);
        if (this.cores != null) {
            builder.append(" (");
            builder.append(this.cores.physical).append(" Cores");
            if (this.cores.logical > 0 && this.cores.logical != this.cores.physical) {
                builder.append(" / ").append(this.cores.logical).append(" Threads");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public static final class Cores {
        public final int physical;
        public final int logical;
        public final int packages;

        public Cores(int logical) {
            this(logical, logical, 1);
        }

        public Cores(int physical, int logical, int packages) {
            this.physical = physical;
            this.logical = logical;
            this.packages = packages;
        }

        public String toString() {
            return String.format("Cores[physical=%d, logical=%d, packages=%d]", this.physical, this.logical, this.packages);
        }
    }

    public static final class Builder {
        private String name;
        @Nullable
        private HardwareVendor vendor;
        @Nullable
        private Cores cores;

        public CentralProcessor build() {
            Object name = this.name;
            if (name == null) {
                name = this.vendor != null ? this.vendor + " Processor" : "Unknown";
            }
            return new CentralProcessor((String)name, this.vendor, this.cores);
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public HardwareVendor getVendor() {
            return this.vendor;
        }

        public Builder setVendor(HardwareVendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public Cores getCores() {
            return this.cores;
        }

        public Builder setCores(Cores cores) {
            this.cores = cores;
            return this;
        }
    }
}

